#ifndef _SQLIMPORT_CPP
#define _SQLIMPORT_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <WindowsX.H>
#include <ShellAPI.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <SQL.H>
#include <SQLExt.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../Resources/Resource.H"
#include "../../SharedClasses/CRC32/CRC.H"
#include "../../SharedClasses/SQLClass/cSQL.H"
#include "../../SharedClasses/SQLClass/cRecordSet.H"
#include "../CSockSrvr/CSockSrvr.H"

#include "NSWFL.H"
#include "Init.H"
#include "Entry.H"
#include "Routines.H"
#include "Command.H"
#include "Console.H"
#include "SQLImport.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

SQLINTEGER CharTrim(char *Data, int Length)
{
    SQLINTEGER Pos = Length;

    if(Length == 0)
        return Length;

    if(Data[Length-1] != ' ')
        return Length;

    Pos--;

    while(Pos != 0 && Data[Pos] == ' ')
        Pos--;

    if(Data[Pos] != ' ')
        Pos++;

    Data[Pos] = '\0';

    return Pos;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void FreeSingleRowDataColumns(struct _SQLImportMembers *SIM, int iColumnCount)
{
    int iColumnPos = 0;
    while(iColumnPos < iColumnCount)
    {
		free(SIM->SingleRowData[iColumnPos]);
        SIM->SingleRowData[iColumnPos] = NULL;
        iColumnPos++;
    }

	SIM->iOutDataType[iColumnPos] = 0;
	SIM->iOutColumnSize[iColumnPos] = 0;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void FreeColumnNames(struct _SQLImportMembers *SIM, int iColumnCount)
{
    int iColumnPos = 0;
    while(iColumnPos < iColumnCount)
    {
        free(SIM->ColumnNames[iColumnPos]);
        SIM->ColumnNames[iColumnPos] = NULL;
        iColumnPos++;
    }

	free(SIM->iOutDataType);
	free(SIM->iOutColumnSize);
	
	free(SIM->ColumnNames);
    SIM->ColumnNames = NULL;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void FreeSingleRowData(struct _SQLImportMembers *SIM)
{
	free(SIM->SingleRowData);
    SIM->SingleRowData = NULL;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool ImportSQLResults(CSockSrvr *pSockSrvr, int iClient, char *InFileName)
{
    char sImportTable[255]; //The name of the table that were gogin to be importing into.
    char sStatusText[MAX_STATUS_TEXT]; //Just some RAM for status text and error messages.
    char sAltTemp[MAX_STATUS_TEXT];    //Just some RAM for status text and error messages.

	char **sUniuqeKeyNames = NULL;        // Contains the names of the uniuqe Columns.
    int *iUniuqeKeyCols = NULL;           // Contains the Column position of the uniuqe Columns.
    int iUniuqeKeysNeeded = 0;            // The ammount of uniuqe keys we have to find.
    int iUniuqeKeysFound = 0;             // The ammount of uniuqe keys we have found.
    int iTotalLengthOfAllColumnNames = 0; // For better memory management.
    int iTotalLengthOfAllRowData = 0;     // For better memory management.
    int iImportTableNameLen = 0;
    int iColumnCount = 0;
    int iRowCount = 0;
    int iColNameLen = 0;
    int iColumnPos = 0;
	bool IsDelete = false; //Is the data we received a list of rows to delete?

    FILE *SourceHandle = NULL;

    _SQLImportMembers SIM;

    CRecordSet rsTemp;

	WriteLog(pSockSrvr->icClientID[iClient], "Importing client data.");

    if((SourceHandle = fopen(InFileName, "rb")) == NULL)
    {
		sprintf(sStatusText, "Error in ImportSQLResultsFailed:: TargetFile open error. Name: \"%s\"\n", InFileName);
		WriteLog(pSockSrvr->icClientID[iClient], sStatusText);

        return false;
    }

    fread(&iImportTableNameLen, sizeof(iImportTableNameLen), 1, SourceHandle); // Read import table name len.
    fread(sImportTable, sizeof(char), iImportTableNameLen, SourceHandle); // Read import table name.
    fread(&iColumnCount, sizeof(iColumnCount), 1, SourceHandle); // Read number of Columns.
    fread(&iRowCount, sizeof(iRowCount), 1, SourceHandle);       // Read number of rows.
    sImportTable[iImportTableNameLen] = '\0';

	if(strcmp(sImportTable, "SQLExch_Statements") == 0)
	{
		CCI[iClient].cCustSQL.ExecuteNonQuery("DELETE FROM SQLExch_Statements");
	}

	char sRight[100];
	Right(sImportTable, sRight, iImportTableNameLen, 15);

	if( strcmp(sRight, "_SQLExch_Delete") == 0)
	{
		IsDelete = true;
		
		//Turncate the import tale. Trimming off the "_SQLExch_Delete"
		sImportTable[iImportTableNameLen - 15] = '\0';
	}

	//Get a list of primary keys for the import table.
	sUniuqeKeyNames = GetPrimaryKeys(&CCI[iClient].cCustSQL, sImportTable, &iUniuqeKeysNeeded, NULL);
	if(iUniuqeKeysNeeded > 0)
	{
		iUniuqeKeyCols = (int *) calloc(sizeof(int), iUniuqeKeysNeeded);
	}
	else{
		//No primary keys, cannot import this data.
		WriteLog(pSockSrvr->icClientID[iClient], "Error in ImportSQLResultsFailed:: Could not obtain a list of primary keys.");

        if(SourceHandle) fclose(SourceHandle);
        return false;
	}

	//Allocate RAM for the list of column names.
	SIM.ColumnNames = (char **) calloc(sizeof(char *), iColumnCount + 1);
	SIM.iOutDataType = (int *) calloc(sizeof(int), iColumnCount + 1);
	SIM.iOutColumnSize = (int *) calloc(sizeof(int), iColumnCount + 1);
    
	//Loop through, reading all of the column name from the file.
	while(iColumnPos < iColumnCount)
    {
        fread(&SIM.iOutDataType[iColumnPos], sizeof(int), 1, SourceHandle);
        fread(&SIM.iOutColumnSize[iColumnPos], sizeof(int), 1, SourceHandle);

		fread(&iColNameLen, sizeof(iColNameLen), 1, SourceHandle);
        SIM.ColumnNames[iColumnPos] = (char *) calloc(sizeof(char), iColNameLen + 1);
        fread(SIM.ColumnNames[iColumnPos], sizeof(char), iColNameLen, SourceHandle);
        SIM.ColumnNames[iColumnPos][iColNameLen] = '\0';
        iTotalLengthOfAllColumnNames = (iTotalLengthOfAllColumnNames + iColNameLen);

        //If this column name matches one of our Primary Keys then record its position
		//	in iUniuqeKeyCols[]
        if(iUniuqeKeysFound < iUniuqeKeysNeeded)
        {
            int UniuqeKeyCount = 0;
            while(UniuqeKeyCount < iUniuqeKeysNeeded)
            {
                if(strcmpi(sUniuqeKeyNames[UniuqeKeyCount], SIM.ColumnNames[iColumnPos]) == 0)
                {
                    iUniuqeKeyCols[UniuqeKeyCount] = iColumnPos;
                    iUniuqeKeysFound++;
                }
                UniuqeKeyCount++;
            }
        }

        iColumnPos++;
    }

	int UniuqeKeyCount = 0;
    while(iUniuqeKeysNeeded < iUniuqeKeysFound)
    {
        sprintf(sStatusText, "Error in ImportSQLResultsFailed:: Required uniuqe keys were not found for: '%s'.", sImportTable);
		WriteLog(pSockSrvr->icClientID[iClient], sStatusText);

        FreeColumnNames(&SIM, iColumnCount);

        if(SourceHandle) fclose(SourceHandle);
        return false;
    }

    if( pSockSrvr->bcConnected[iClient] == false )
    {
		if(IsDelete)
		{
			WriteLog(pSockSrvr->icClientID[iClient], "Disconnected before data import.");
		}
		else{
			WriteLog(pSockSrvr->icClientID[iClient], "Disconnected before data deletion.");
		}

        if(SourceHandle) fclose(SourceHandle);
        return false;
    }

	if(IsDelete)
	{
		WriteLog(pSockSrvr->icClientID[iClient], "Starting data deletion.");
	}
	else{
		WriteLog(pSockSrvr->icClientID[iClient], "Starting data import.");
	}

    //Allocate an Array large enough to hold all of the row data.
	SIM.SingleRowData = (char **) calloc(sizeof(char *), iColumnCount + 1);

	int RowDataLen = 0;

    int RowPos = 0;
    while(RowPos < iRowCount)
    {
        int BaseMemoryRequirement = 0;
        iTotalLengthOfAllRowData = 0;

        // Get row data.
        iColumnPos = 0;
        while(iColumnPos < iColumnCount)
        {
            fread(&RowDataLen, sizeof(RowDataLen), 1, SourceHandle);
            SIM.SingleRowData[iColumnPos] = (char *) calloc(sizeof(char), RowDataLen + 1);
            fread(SIM.SingleRowData[iColumnPos], sizeof(char), RowDataLen, SourceHandle);
			
            SIM.SingleRowData[iColumnPos][RowDataLen] = '\0';
            iTotalLengthOfAllRowData = (iTotalLengthOfAllRowData + RowDataLen);
            iColumnPos++;
        }

        BaseMemoryRequirement = ((iTotalLengthOfAllColumnNames + iTotalLengthOfAllRowData) + (iColumnCount * 5)) + 1024;

        char WhereStatement[1024];
        char CheckExistanceStatement[1024];

        // Assemble the where statement from the row data, the uniuqe key names and positions.
        if(iUniuqeKeysFound > 0)
        {
            // Assemble the where statement
            sprintf(WhereStatement, "WHERE %s = %s", sUniuqeKeyNames[0], SIM.SingleRowData[iUniuqeKeyCols[0]]);
        	int UniuqeKeyCount = 1;
            while(UniuqeKeyCount < iUniuqeKeysFound)
            {
                strcat(WhereStatement, " AND ");
                strcat(WhereStatement, sUniuqeKeyNames[UniuqeKeyCount]);
                strcat(WhereStatement, " = ");
                strcat(WhereStatement, SIM.SingleRowData[iUniuqeKeyCols[UniuqeKeyCount]]);
                UniuqeKeyCount++;
            }

            // Assemble the check existance statement
            sprintf(CheckExistanceStatement, "SELECT %s", sUniuqeKeyNames[0]);
            strcat(CheckExistanceStatement, " FROM ");
            strcat(CheckExistanceStatement, sImportTable);
            strcat(CheckExistanceStatement, " ");
            strcat(CheckExistanceStatement, WhereStatement);
        }

		if(iUniuqeKeysFound > 0)
		{
			if(!CCI[iClient].cCustSQL.Execute(CheckExistanceStatement, &rsTemp))
			{
				WriteLog(pSockSrvr->icClientID[iClient], "Error in ImportSQLResultsFailed:: Execute failed on CheckExistanceStatement.");

				sprintf(sStatusText, "Statement: %s", CheckExistanceStatement);
				WriteLog(pSockSrvr->icClientID[iClient], sStatusText);

				//Need to do some advanced error reporting.
				if(CCI[iClient].cCustSQL.GetErrorMessage(sAltTemp, rsTemp.hSTMT))
				{
					sprintf(sStatusText, "Error Msg: %s", sAltTemp);
					WriteLog(pSockSrvr->icClientID[iClient], sStatusText);
				}

				FreeSingleRowDataColumns(&SIM, iColumnCount);
				FreeSingleRowData(&SIM);
				FreeColumnNames(&SIM, iColumnCount);

				if(SourceHandle) fclose(SourceHandle);
				return false;
			}
		}

        int iCountOfRowsThatAlreadyExist = rsTemp.RowCount;

        rsTemp.Close();

        char *sSrvSQL = NULL;
        bool bFreeSrvSQL = false;

        //----------------------------------------------------------------------------------------------
        if(IsDelete)
		{
			if(iCountOfRowsThatAlreadyExist > 0)
			{
				sSrvSQL = (char *) calloc( sizeof(char), BaseMemoryRequirement + 1);
				bFreeSrvSQL = true;

				sprintf(sSrvSQL, "DELETE FROM %s %s", sImportTable, WhereStatement);
			}
			else{
				WriteLog(pSockSrvr->icClientID[iClient], "Deletion target was not found.");
				giWarningCount++;
			}
		}
		else if(iCountOfRowsThatAlreadyExist == 0) // Do insert
        {
			sSrvSQL = (char *) calloc( sizeof(char), BaseMemoryRequirement + 1);
            bFreeSrvSQL = true;

			sprintf(sSrvSQL, "INSERT INTO %s (", sImportTable);

            iColumnPos = 0;
            while(iColumnPos < iColumnCount)
            {
                strcat(sSrvSQL, SIM.ColumnNames[iColumnPos]);
                if(iColumnPos < iColumnCount - 1)
                {
                    strcat(sSrvSQL, ",");
                }
                iColumnPos++;
            }
            strcat(sSrvSQL, ") VALUES(");

            iColumnPos = 0;
            while(iColumnPos < iColumnCount)
            {
				strcat(sSrvSQL, SIM.SingleRowData[iColumnPos]);
                if(iColumnPos < iColumnCount - 1)
                {
                    strcat(sSrvSQL, ",");
                }
                iColumnPos++;
            }
            strcat(sSrvSQL, ") ");
        }
        //----------------------------------------------------------------------------------------------
        else { // Do update
            BaseMemoryRequirement = (BaseMemoryRequirement + strlen(WhereStatement));
            sSrvSQL = (char *) calloc( sizeof(char), BaseMemoryRequirement + 1);
            bFreeSrvSQL = true;

            sprintf(sSrvSQL, "UPDATE %s SET ", sImportTable);

            iColumnPos = 0;
            while(iColumnPos < iColumnCount)
            {
                strcat(sSrvSQL, SIM.ColumnNames[iColumnPos]);
                strcat(sSrvSQL, "=");
                strcat(sSrvSQL, SIM.SingleRowData[iColumnPos]);
                if(iColumnPos < iColumnCount - 1)
                {
                    strcat(sSrvSQL, ",");
                }
                iColumnPos++;
            }

            strcat(sSrvSQL, " ");
            strcat(sSrvSQL, WhereStatement);
        }

        //----------------------------------------------------------------------------------------------

        if(sSrvSQL != NULL)
        {
			if(!CCI[iClient].cCustSQL.Execute(sSrvSQL, &rsTemp))
            {
				WriteLog(pSockSrvr->icClientID[iClient], "Error in ImportSQLResultsFailed:: Execute failed on sSrvSQL.");

				sprintf(sStatusText, "Statement: %s", sSrvSQL);
				WriteLog(pSockSrvr->icClientID[iClient], sStatusText);

				//Need to do some advanced error reporting.
				if(CCI[iClient].cCustSQL.GetErrorMessage(sAltTemp, rsTemp.hSTMT))
				{
					sprintf(sStatusText, "Error Msg: %s", sAltTemp);
					WriteLog(pSockSrvr->icClientID[iClient], sStatusText);
				}

				FreeSingleRowDataColumns(&SIM, iColumnCount);
                FreeSingleRowData(&SIM);
                FreeColumnNames(&SIM, iColumnCount);

                free(sSrvSQL);

                if(SourceHandle) fclose(SourceHandle);
                return false;
            }

            rsTemp.Close();
        }

        if(bFreeSrvSQL)
		{
            free(sSrvSQL);
		}

        sSrvSQL = NULL;

        FreeSingleRowDataColumns(&SIM, iColumnCount);
        //FreeSingleRowData(&SIM); // This memory needs to stay intact untill we are done with the import.

        iColumnPos++;

        RowPos++;

        if( pSockSrvr->bcConnected[iClient] == false )
        {
		    sprintf(sStatusText, "Disconnected durring data import, after %d successful rows.", RowPos);
			WriteLog(pSockSrvr->icClientID[iClient], sStatusText);

            FreeSingleRowData(&SIM);
            FreeColumnNames(&SIM, iColumnCount);

            if(SourceHandle) fclose(SourceHandle);
            return false;
        }
    }

    if(IsDelete)
	{
		sprintf(sStatusText, "Successfully deleted %d client data rows.", RowPos);
	}
	else{
		sprintf(sStatusText, "Successfully imported %d client data rows.", RowPos);
	}
	WriteLog(pSockSrvr->icClientID[iClient], sStatusText);

	if(iUniuqeKeysNeeded > 0)
	{
		FreePrimaryKeys(sUniuqeKeyNames, iUniuqeKeysNeeded);
		free(iUniuqeKeyCols);
	}

	FreeSingleRowData(&SIM);
    FreeColumnNames(&SIM, iColumnCount); 

    if(SourceHandle) fclose(SourceHandle);

    return true;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

char **GetPrimaryKeys(CSQL *pcSQL, char *sTableName, int *iNumOfKeys, char *sPKName)
{
	int iPKCount = 0;
	int iPKColLen = 0;

	char sSQL[1024];
	char sPKCol[256];
	char *sBaseSQL = NULL;
	char **sOutKeys = NULL;

	bool bGetPKName = true;

    CRecordSet rsTemp;

	sBaseSQL = "SELECT sysobjects.parent_obj AS tableid, 'PK' AS constraintType,"
		" sysobjects.name AS constraintName, syscolumns.name AS keyColumn, sysindexkeys.KeyNo"
		" FROM sysobjects"
		" INNER JOIN sysindexes ON sysobjects.name = sysindexes.name"
		" INNER JOIN sysindexkeys ON sysindexes.indid = sysindexkeys.indid AND sysindexes.id = sysindexkeys.id"
		" INNER JOIN syscolumns ON sysindexkeys.colid = syscolumns.colid AND sysobjects.parent_obj = syscolumns.id"
		" WHERE sysobjects.xtype = 'PK' and sysobjects.parent_obj = object_id('%s')"
		" Order by sysindexkeys.KeyNo";

	sprintf(sSQL, sBaseSQL, sTableName);

	if(!pcSQL->Execute(sSQL, &rsTemp))
	{
		return NULL;
	}

	if(sPKName == NULL)
	{
		bGetPKName = false;
	}
	
	if(rsTemp.RowCount > 0)
	{
		sOutKeys = (char **) calloc(sizeof(char *), rsTemp.RowCount + 1);

		while(rsTemp.Fetch())
		{
			iPKColLen = 0;

			if(bGetPKName)
			{
				rsTemp.sColumnEx(3, sPKName, 255, &iPKColLen);
				bGetPKName = false;
			}

			rsTemp.sColumnEx(4, sPKCol, sizeof(sPKCol), &iPKColLen);

			if(iPKColLen > 0)
			{
				sOutKeys[iPKCount] = (char *) calloc(sizeof(char), iPKColLen + 1);
				strcpy(sOutKeys[iPKCount], sPKCol);
				iPKCount++;
			}

		}

		sOutKeys[iPKCount] = NULL;
	}
	else{
		sOutKeys = NULL;
	}

	rsTemp.Close();

	*iNumOfKeys = iPKCount;

	return sOutKeys;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

char **GetPrimaryKeysEx(CSQL *pcSQL, char *sTableName, char *sDBO, char *sDB, int *iNumOfKeys, char *sPKName)
{
	int iPKCount = 0;
	int iPKColLen = 0;

	char sSQL[5120];
	char sPKCol[256];
	char *sBaseSQL = NULL;
	char **sOutKeys = NULL;

	bool bGetPKName = true;

    CRecordSet rsTemp;

	sBaseSQL = "SELECT %s.[%s].sysobjects.parent_obj AS tableid, 'PK' AS constraintType,"
		" %s.[%s].sysobjects.name AS constraintName, %s.[%s].syscolumns.name AS keyColumn, %s.[%s].sysindexkeys.KeyNo"
		" FROM %s.[%s].sysobjects"
		" INNER JOIN %s.[%s].sysindexes ON %s.[%s].sysobjects.name = %s.[%s].sysindexes.name"
		" INNER JOIN %s.[%s].sysindexkeys ON %s.[%s].sysindexes.indid = %s.[%s].sysindexkeys.indid AND %s.[%s].sysindexes.id = %s.[%s].sysindexkeys.id"
		" INNER JOIN %s.[%s].syscolumns ON %s.[%s].sysindexkeys.colid = %s.[%s].syscolumns.colid AND %s.[%s].sysobjects.parent_obj = %s.[%s].syscolumns.id"
		" WHERE %s.[%s].sysobjects.xtype = 'PK' and %s.[%s].sysobjects.parent_obj = object_id('%s.[%s].%s')"
		" Order by %s.[%s].sysindexkeys.KeyNo";

	sprintf(sSQL, sBaseSQL, sDB, sDBO, sDB, sDBO, sDB, sDBO, sDB, sDBO, sDB, sDBO,
		sDB, sDBO, sDB, sDBO, sDB, sDBO, sDB, sDBO, sDB, sDBO, sDB, sDBO, sDB,
		sDBO, sDB, sDBO, sDB, sDBO, sDB, sDBO, sDB, sDBO, sDB, sDBO, sDB, sDBO,
		sDB, sDBO, sDB, sDB, sTableName, sDBO, sDB);

	if(!pcSQL->Execute(sSQL, &rsTemp))
	{
		return NULL;
	}

	if(sPKName == NULL)
	{
		bGetPKName = false;
	}
	
	if(rsTemp.RowCount > 0)
	{
		sOutKeys = (char **) calloc(sizeof(char *), rsTemp.RowCount + 1);

		while(rsTemp.Fetch())
		{
			iPKColLen = 0;

			if(bGetPKName)
			{
				rsTemp.sColumnEx(3, sPKName, 255, &iPKColLen);
				bGetPKName = false;
			}

			rsTemp.sColumnEx(4, sPKCol, sizeof(sPKCol), &iPKColLen);

			if(iPKColLen > 0)
			{
				sOutKeys[iPKCount] = (char *) calloc(sizeof(char), iPKColLen + 1);
				strcpy(sOutKeys[iPKCount], sPKCol);
				iPKCount++;
			}

		}

		sOutKeys[iPKCount] = NULL;
	}
	else{
		sOutKeys = NULL;
	}

	rsTemp.Close();

	*iNumOfKeys = iPKCount;

	return sOutKeys;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void FreePrimaryKeys(char **sOutKeys, int iKeys)
{
	int iPos = 0;

	if(iKeys > 0)
	{
		while(iPos < iKeys)
		{
			free(sOutKeys[iPos]);
			iPos++;
		}
	}

	free(sOutKeys);
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool PrepareAllCustomerDBs(void)
{
	char sSQL[1024];
	char sDB[1024];
	char sColumn[1024];
	char sStatus[1024];
	char sTable[1024];
	char sType[255];
	char sPKName[255];

	int iSize = 0;

	CSQL CustSQL;
	CSQL IndexSQL;

	CRecordSet rsTables;
	CRecordSet rsDBs;
	CRecordSet rsID;
	CRecordSet rsRows;

    if(!IndexSQL.Connect(gsSQLIndexDriver, gsSQLIndexServer, gsSQLIndexUserID, gsSQLIndexPassword, gsSQLIndexDatabase))
    {
        MsgBox("Error connecting to the index database.");
        return false;
    }


	strcpy(sSQL, "SELECT CompDB FROM Companys");
	IndexSQL.Execute(sSQL, &rsDBs);

	while(rsDBs.Fetch())
	{
		rsDBs.sColumnEx(1, sDB, sizeof(sDB), &iSize);

		if(!CustSQL.Connect(gsSQLCustDriver, gsSQLCustServer, gsSQLCustUserID, gsSQLCustPassword, sDB))
		{
			sprintf(sStatus, "Could not connect to the [%s] database", sDB);
			//MsgBox(sStatus);
		}
		else{
			strcpy(sSQL, "SELECT Name"
				" FROM SysObjects"
				" WHERE xType = 'U' AND LEFT(NAME, 8) <> 'SQLExch_'"
				" AND Name <> 'dtProperties'"
				" ORDER BY Name");

			if(CustSQL.Execute(sSQL, &rsTables))
			{
				while(rsTables.Fetch())
				{
					char **sPKs = NULL;
					int iPKs = 0;
					int iPK = 0;

					rsTables.sColumnEx(1, sTable, sizeof(sTable), &iSize);

					sPKs = GetPrimaryKeys(&CustSQL, sTable, &iPKs, sPKName);

					if(iPKs)
					{
						int iRows = 0;
						sprintf(sSQL, "Select [%s] From [%s]", sPKs[0], sTable);
						CustSQL.Execute(sSQL, &rsRows);

						iRows = rsRows.RowCount;

						rsRows.Close();

						//We cannot drop the ID columns from a table with rows.
						if(iRows == 0)
						{
							//Drop the existing Primary Key.
							sprintf(sSQL, "ALTER TABLE [%s] Drop [%s]", sTable, sPKName);
							CustSQL.ExecuteNonQuery(sSQL);

							//-------------------------------------------------------------
							//Get a list of all of the identity columns in the table.
							sprintf(sSQL, "SELECT SysColumns.Name, SysTypes.Name"
								" FROM SysColumns, SysObjects, SysTypes"
								" WHERE SysObjects.ID = SysColumns.ID AND"
								" SysTypes.xType = SysColumns.xType"
								" AND SysObjects.Name = '%s'"
								" AND ColStat = 1", sTable);

							CustSQL.Execute(sSQL, &rsID);
						
							//Drop and recreate all of the ID columns.
							while(rsID.Fetch())
							{
								rsID.sColumnEx(1, sColumn, sizeof(sColumn), &iSize);
								rsID.sColumnEx(2, sType, sizeof(sType), &iSize);

								if(rsID.RowCount == 1)
								{
									//This is dirty, but we need to add a temp column just
									//	incase the table only contains one column.
									sprintf(sSQL, "ALTER TABLE %s\r\n"
										"ADD [%s_TEMP] %s", sTable, sColumn, sType);
									CustSQL.ExecuteNonQuery(sSQL);
								}
							
								sprintf(sSQL, "ALTER TABLE %s\r\n"
									"DROP COLUMN [%s]", sTable, sColumn);
								CustSQL.ExecuteNonQuery(sSQL);

								sprintf(sSQL, "ALTER TABLE %s\r\n"
									"ADD [%s] %s NOT NULL DEFAULT 0", sTable, sColumn, sType);
								CustSQL.ExecuteNonQuery(sSQL);

								if(rsID.RowCount == 1)
								{
									//Drop the temp column.
									sprintf(sSQL, "ALTER TABLE %s\r\n"
										"DROP COLUMN [%s_TEMP]", sTable, sColumn);
									CustSQL.ExecuteNonQuery(sSQL);
								}

							}

							rsID.Close();
	
							//-------------------------------------------------------------------
							//Recreate the primary key.

							sprintf(sSQL, "ALTER TABLE [%s] ADD\r\n"
								" CONSTRAINT [%s] PRIMARY KEY CLUSTERED\r\n"
								" (", sTable, sPKName);

							while(iPK < iPKs)
							{
								strcat(sSQL, "[");
								strcat(sSQL, sPKs[iPK]);
								strcat(sSQL, "]");

								if(iPK != iPKs - 1)
								{
									strcat(sSQL, ",");
								}

								iPK++;
							}
							strcat(sSQL, " ) ON [PRIMARY]");

							CustSQL.ExecuteNonQuery(sSQL);
							//-------------------------------------------------------------------
						}
					}
					FreePrimaryKeys(sPKs, iPKs);
				}
			}

			rsTables.Close();

			CustSQL.Disconnect();
		}
	}

	rsDBs.Close();
	IndexSQL.Disconnect();

	return true;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
